/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.DebugOutput;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

class LWOBFileReader
extends BufferedInputStream {
    static final int TRACE = 1;
    static final int VALUES = 2;
    static final int MISC = 4;
    static final int LINE_TRACE = 8;
    static final int NONE = 0;
    static final int EXCEPTION = 16;
    protected DebugOutput debugPrinter = new DebugOutput(127);
    protected String theFilename;
    protected int marker = 0;

    protected void debugOutputLn(int n2, String string) {
        if (string.equals("")) {
            this.debugPrinter.println(n2, string);
        } else {
            this.debugPrinter.println(n2, this.getClass().getName() + "::" + string);
        }
    }

    public String getToken() throws ParsingErrorException {
        byte[] byArray = new byte[4];
        try {
            int n2 = this.read(byArray, 0, 4);
            if (n2 == -1) {
                this.debugOutputLn(8, "no token - returning null");
                return null;
            }
            return new String(byArray);
        }
        catch (IOException iOException) {
            this.debugOutputLn(16, "getToken: " + iOException);
            throw new ParsingErrorException(iOException.getMessage());
        }
    }

    public void skipLength(int n2) throws ParsingErrorException {
        try {
            this.skip(n2);
            this.marker += n2;
        }
        catch (IOException iOException) {
            this.debugOutputLn(16, "skipLength: " + iOException);
            throw new ParsingErrorException(iOException.getMessage());
        }
    }

    public int getInt() throws ParsingErrorException {
        try {
            int n2 = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                int n3 = this.read();
                if (n3 == -1) {
                    throw new ParsingErrorException("Unexpected EOF");
                }
                n2 = n2 << 8 | n3;
            }
            return n2;
        }
        catch (IOException iOException) {
            this.debugOutputLn(16, "getInt: " + iOException);
            throw new ParsingErrorException(iOException.getMessage());
        }
    }

    public float getFloat() throws ParsingErrorException {
        return Float.intBitsToFloat(this.getInt());
    }

    public String getFilename() {
        return this.theFilename;
    }

    public String getString() throws ParsingErrorException {
        byte[] byArray = new byte[512];
        try {
            byte by;
            int n2 = 0;
            do {
                by = (byte)this.read();
                byArray[n2++] = by;
            } while (by != 0);
            if (n2 % 2 != 0) {
                this.read();
            }
        }
        catch (IOException iOException) {
            this.debugOutputLn(16, "getString: " + iOException);
            throw new ParsingErrorException(iOException.getMessage());
        }
        return new String(byArray);
    }

    public void getVerts(float[] fArray, int n2) throws ParsingErrorException {
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2 * 3 + 0] = this.getFloat();
            fArray[i2 * 3 + 1] = this.getFloat();
            fArray[i2 * 3 + 2] = -this.getFloat();
        }
    }

    public int getShortInt() throws ParsingErrorException {
        int n2 = 0;
        try {
            n2 = this.read();
            n2 = n2 << 8 | this.read();
            if ((n2 & 0x8000) != 0) {
                n2 |= 0xFFFF0000;
            }
        }
        catch (IOException iOException) {
            this.debugOutputLn(16, "getShortInt: " + iOException);
            throw new ParsingErrorException(iOException.getMessage());
        }
        return n2;
    }

    public int getMarker() {
        return this.marker;
    }

    public int read() throws IOException {
        ++this.marker;
        return super.read();
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = super.read(byArray, n2, n3);
        if (n4 != -1) {
            this.marker += n4;
        }
        return n4;
    }

    public LWOBFileReader(String string) throws FileNotFoundException {
        super(new FileInputStream(string));
    }

    public LWOBFileReader(URL uRL) throws IOException {
        super(uRL.openStream());
    }
}

